#ifndef __IFileBrowserValidator__
#define __IFileBrowserValidator__

#include <Host/CFileInformation.hpp>
using Exponent::Host::CFileInformation;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IFileBrowserValidator IFileBrowserValidator.hpp
			 * @brief Allows you to validate an entry in a file browser tree
			 *
			 * @date 28/06/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IFileBrowserValidator.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IFileBrowserValidator
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IFileBrowserValidator() { }
				
				/**
				 * Destruction
				 */
				virtual ~IFileBrowserValidator() { }

//	===========================================================================

				/**
				 * Validate if a file should be shown
				 * @param info The file information
				 * @retval bool True if the file should be shown, false otherwise
				 */
				virtual bool validateFile(const CFileInformation &info) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IFileBrowserValidator.hpp